<?php

namespace App\Http\Controllers;

use App\Models\Modul;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

use Mike42\Escpos\PrintConnectors\FilePrintConnector;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\Printer;

class SettingController extends Controller
{
    public function banner()
    {
        $banner = Modul::latest()->get();
        $slid = Modul::where('kode', 'BNS')->get();
        $ban_atas = Modul::where('kode', 'BNA')->get();
        $ban_bawah = Modul::where('kode', 'BNB')->get();
        $data = [
            'title' => 'Ramizah Store | Banner Slideshow',
            'page' => 'Banner Slideshow',
            'menuActive' => 'banner',
            'menuOpen' => 'setting',
        ];
        return view('admin.setting.banner', compact('data', 'slid', 'banner', 'ban_atas', 'ban_bawah'))->with('no', 1);
    }

    public function tambah_banner(Request $request)
    {
        if ($request->hasFile('gambar')) {
            // //upload image
            $image = $request->file('gambar');
            $image->storeAs('public/banner', $image->hashName());
            $isi = $image->hashName();
        } else {
            $isi = '';
        }

        Modul::create([
            'kode' => $request->kode,
            'judul' => $request->judul,
            'isi' => $request->isi,
            'link' => $request->link,
            'gambar' =>  $isi,
            'status' => 'Y',
            // 'tgl1' => '',
            // 'tgl2' => '',
        ]);

        return redirect('setting-banner-slideshow')->with(['success' => 'Data Berhasil Disimpan!']);
    }

    public function edit_banner(Request $request)
    {
        $id = $request->id;
        $gbrlama = $request->gbrlama;

        $modul = Modul::findOrFail($id);
        if ($request->hasFile('gambar')) {
            // //upload image
            $image = $request->file('gambar');
            $image->storeAs('public/banner', $image->hashName());
            if ($gbrlama != null) {
                Storage::delete('public/banner/' .  $gbrlama);
            }
            $modul->update([
                'gambar'             => $image->hashName(),
            ]);
        }

        $modul->update([
            'judul' => $request->judul,
            'isi' => $request->isi,
            'link' => $request->link,
        ]);

        return redirect('setting-banner-slideshow')->with(['success' => 'Edit Data Berhasil Disimpan!']);
    }

    public function destroy($id)
    {
        $img = Modul::where('id', $id)->first();
        if ($img->gambar != null) {
            Storage::delete('public/banner/' .  $img->gambar);
        }
        Modul::findOrFail($id)->delete();
        return redirect('setting-banner-slideshow')->with(['success' => 'Data berhasil dihapus!']);
    }

    public function status_banner(Request $request)
    {
        $id = $request->id;

        $modul = Modul::findOrFail($id);
        $modul->update([
            'status' => $request->isi,
        ]);
        return response()->json();
    }

    public function detail_banner(Request $request)
    {
        $m = Modul::where('id', $request->id)->first();
        return view('admin.setting.detail_banner', compact('m'));
    }

    // diskon

    public function diskon()
    {
        $modul = Modul::where('kode', 'DISC')->get();
        $data = [
            'title' => 'Ramizah Store | Diskon',
            'page' => 'Diskon',
            'menuActive' => 'diskon',
            'menuOpen' => 'setting',
        ];
        return view('admin.setting.diskon', compact('data', 'modul'))->with('no', 1);
    }

    public function tambah_diskon(Request $request)
    {
        $date = date('Y-m-d 23:50:00', strtotime($request->tgl2));
        Modul::create([
            'kode' => 'DISC',
            'judul' => $request->judul_diskon,
            'isi' => $request->diskon,
            'link' => '-',
            'gambar' => '-',
            'status' => 'N',
            'tgl1' => $request->tgl1,
            'tgl2' => $date,
        ]);

        return redirect('setting-diskon')->with(['success' => 'Data Berhasil Disimpan!']);
    }


    public function edit_diskon(Request $request)
    {
        $id = $request->id;
        $modul = Modul::findOrFail($id);
        $date = date('Y-m-d 23:50:00', strtotime($request->tgl2));
        $modul->update([
            'judul' => $request->judul_diskon,
            'isi' => $request->diskon,
            'tgl1' => $request->tgl1,
            'tgl2' => $date,
        ]);

        return redirect('setting-diskon')->with(['success' => 'Edit Data Berhasil Disimpan!']);
    }

    public function status_diskon(Request $request)
    {
        $id = $request->id;
        $cek = Modul::where('kode', 'DISC')->where('status', 'Y')->first();

        $modul = Modul::findOrFail($id);
        if ($request->isi == 'Y') {
            if (!empty($cek->id)) {
                $m = Modul::findOrFail($cek->id);
                $m->update([
                    'status' => 'N',
                ]);
            }
        }
        $modul->update([
            'status' => $request->isi,
        ]);

        return response()->json();
    }

    public function destroy_diskon($id)
    {
        Modul::findOrFail($id)->delete();
        return redirect('setting-diskon')->with(['success' => 'Data berhasil dihapus!']);
    }

    // struk poin

    public function struk_poin()
    {
        $struk = Modul::where('kode', 'STR')->get();
        $poin = Modul::where('kode', 'POIN')->get();
        $data = [
            'title' => 'Ramizah Store | Struk & Poin',
            'page' => 'Struk & Poin',
            'menuActive' => 'struk_poin',
            'menuOpen' => 'setting',
        ];
        return view('admin.setting.poin_struk', compact('data'));
    }

    public function edit_modul(Request $request)
    {
        $field = $request->field;
        $modul = Modul::findOrFail($request->id);
        if ($request->value == "") {
        } else {
            $modul->update([
                $field => $request->value,
            ]);
        }
        return response()->json();
    }

    public function print()
    {
        $connector = new WindowsPrintConnector(modull('PRINT')->isi);
        $printer = new Printer($connector);
        $printer->initialize();
        $printer->setJustification(Printer::JUSTIFY_CENTER);
        $printer->text("Halo Bro...... ini tes percobaan printer");

        $printer->initialize();
        $printer->setJustification(Printer::JUSTIFY_CENTER);
        $printer->text("TERIMA KASIH\n");

        $printer->feed(3);
        $printer->close();
        return redirect('struk-poin')->with(['success' => 'Print data berhasil']);
    }
}
